/*
Let's recap on all of the different component events we can listen for...

- There are lots of different events to listen to. For a list, please see the JsDocs for baja.Subscriber#attach.
- There's also a 'detach' method to remove handlers.
- There are many different ways to attach event handlers as shown in the commented out examples below...
*/

var sub = new baja.Subscriber();

// Attaching a single event listener function...
/*
sub.attach("changed", function(prop, cx) {
  baja.outln("Property changed: " + prop.getName());
});
*/

// Attach one function to multiple events...
/*
sub.attach("subscribed changed added removed", function() {
  baja.outln("Event received: " + this.toPathString());
});
*/

// Use an Object Literal to define multiple event handlers in one call...
sub.attach({
  changed: function(prop, cx) {
    baja.outln("Changed");
  },
  
  added: function(prop, cx) {
    baja.outln("Added");
  },

  removed: function(prop, val, cx) {
    baja.outln("Removed");
  },
  
  renamed: function(prop, oldName, cx) {
    baja.outln("Renamed");
  },

  reordered: function(cx) {
    baja.outln("Reordered");
  },
  
  topicFired: function(topic, event, cx) {
    baja.outln("Topic Fired");
  },
  
  flagsChanged: function(slot, cx) {
    baja.outln("Flags Changed");
  },

  facetsChanged: function(slot, cx) {
    baja.outln("Facets Changed");
  },

  subscribed: function(cx) {
    baja.outln("Subscribed");
  },

  unsubscribed: function(cx) {
    baja.outln("Unsubscribed");
  },
  
  unmount: function(cx) {
    baja.outln("EventTest removed from Station!");
  },
  
  componentRenamed: function(oldName, cx) {
    baja.outln("Original EventTest has been renamed: " + oldName);
  },
  
  componentFlagsChanged: function(cx) {
    baja.outln("EventTest parent Property flags changed");
  },
  
  componentFacetsChanged: function(cx) {
    baja.outln("EventTest parent Property facets changed");
  },
  
  componentReordered: function(cx) {
    baja.outln("EventTest has been reordered in parent");
  }
});

baja.Ord.make("station:|slot:/BajaScriptTutorials/EventTest").get({subscriber: sub});

// Note that if other students are also going through this tutorial on this Station right now, then you may see some unexpected results!
